const db = require("../db");
require("dotenv").config({ path: __dirname + "/../../../.env" });
const jwt = require("jsonwebtoken");


// module.exports.isAuthenticated = async (req, res, next) => {
//   const authHeader = req.headers.authorization;

//   if (!authHeader)
//     return res.status(401).json({ error: true, message: "Token ausente" });

//   const token = authHeader.split(" ")[1];

//   jwt.verify(token, process.env.JWT_SECRET, (err, decoded) => {
//     if (err)
//       return res.status(401).json({ error: true, message: "Token inválido" });

//     db.query("SELECT id, auth, role FROM user WHERE id = ?", [decoded.id], (error, results) => {
//       if (error) {
//         console.error(error);
//         return res.status(500).json({ error: true, message: "Erro no servidor" });
//       }

//       if (!results.length || results[0].auth !== token) {
//         return res.status(401).json({
//           error: true,
//           message: "Token expirado ou revogado"
//         });
//       }

//       // adiciona dados do user na req
//       req.user = {
//         id: decoded.id,
//         role: results[0].role
//       };

//       next();
//     });
//   });
// };


module.exports.isAuthenticated = async (req, res, next) => {
  const authHeader = req.headers.authorization;

  if (!authHeader)
    return res.status(401).json({ error: true, message: "Token ausente" });

  const token = authHeader.split(" ")[1];

  jwt.verify(token, process.env.JWT_SECRET, async (err, decoded) => {
    if (err)
      return res.status(401).json({ error: true, message: "Token inválido" });

    const tabelas = [
      { tabela: "admins", tipo: "admin" },
      { tabela: "usuarios", tipo: "USER" },

    ];

    try {
      let usuario = null;

      for (let item of tabelas) {
        const [rows] = await db.query(
          `SELECT id, auth FROM ${item.tabela} WHERE id = ?`,
          [decoded.id]
        );

        if (rows.length > 0) {
          usuario = { ...rows[0], tipo: item.tipo };
          break;
        }
      }

      if (!usuario)
        return res.status(401).json({ error: true, message: "Usuário não encontrado" });

      // Verifica se o token atual é o mesmo salvo no BD
      if (usuario.auth !== token) {
        return res.status(401).json({
          error: true,
          message: "Token expirado ou revogado"
        });
      }

      // Anexa infos na req
      req.user = {
        id: decoded.id,
        role: usuario.tipo
      };

      next();

    } catch (e) {
      console.error(e);
      return res.status(500).json({ error: true, message: "Erro no servidor" });
    }
  });
};


module.exports.isAdmin = (req, res, next) => {
  if (!req.user) {
    return res.status(500).json({ error: true, message: "Erro na autenticação" });
  }

  if (req.user.role !== "ADMIN") {
    return res.status(403).json({ error: true, message: "Acesso não autorizado. Apenas admins." });
  }

  next();
};