const AtividadesRepository = require("./atividades.repository");

class AtividadesController {
  #atividades;

  constructor(atividadesRepository = new AtividadesRepository()) {
    this.#atividades = atividadesRepository;
  }

  /**
   * Registra uma atividade
   */
  register() {
    return async (req, res) => {
      try {
        const data = req.body;
        const response = await this.#atividades.register(data);

        if (response.error) return res.status(response.code).json(response);
        return res.status(response.code).json(response);

      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Lista todas as atividades
   */
  getAtividades() {
    return async (req, res) => {
      try {
        const response = await this.#atividades.getAtividades();

        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);

      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Busca uma atividade por ID
   */
  getUmaAtividade() {
    return async (req, res) => {
      try {
        const id = req.params.id;
        const response = await this.#atividades.getUmaAtividade(id);

        return res.status(200).json(response);

      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Deleta uma atividade
   */
  delete() {
    return async (req, res) => {
      try {
        const id = req.params.id;
        const response = await this.#atividades.delete(id);

        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);

      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Atualiza uma atividade
   */
  update() {
    return async (req, res) => {
      try {
        const data = req.body;
        const response = await this.#atividades.update(data);

        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);

      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }
}

module.exports = AtividadesController;
