const BoletosRepository = require("./boletos.repository");

class BoletosController {
  async create(req, res) {
    try {
      const data = req.body;
      const response = await BoletosRepository.create(data);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async criarAssinaturaBoleto(req, res) {
    try {
      const data = req.body;
      const response = await BoletosRepository.createAssinatura(data);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async getBoletosAtrasados(req, res) {
    try {
      const response = await BoletosRepository.getBoletosAtrasados();
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  
  async getBoletos(req, res) {
    try {
      const response = await BoletosRepository.getBoletos();
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async getTotalConta(req, res) {
    try {
      const response = await BoletosRepository.getTotalConta();
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async getQtdeBoletosNaoPagos(req, res) {
    try {
      const response = await BoletosRepository.getQtdeBoletosNaoPagos();
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async getUmBoleto(req, res) {
    try {
      const id = req.params.id;
      const response = await BoletosRepository.getUmBoleto(id);
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

    async getBoletosPendentes(req, res) {
    try {
      const response = await BoletosRepository.getBoletosPendentes();
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async update(req, res) {
    try {
      const data = req.body;
      const response = await BoletosRepository.update(data);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async delete(req, res) {
    try {
      const id = req.params.id;
      const response = await BoletosRepository.delete(id);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async gerarBoletoComNota(req, res) {
    try {
      const data = req.body;

      const response = await BoletosRepository.gerarBoletoComNota(data);
      return res.status(response.code || 200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async setBoletosStatus(req, res) {
    try {
      const paymentId = req.params.paymentId;
      const response = await BoletosRepository.setBoletosStatus(paymentId);
      return res.status(response.code || 200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }
}

module.exports = new BoletosController();
