const express = require("express");
const routes = express.Router();
const auth = require("../../config/auth/auth.js");

const BoletosController = require("./boletos.controller");


routes.get("/pendentes", BoletosController.getBoletosPendentes);
routes.get("/nao-pagos", BoletosController.getQtdeBoletosNaoPagos);
routes.post("/", BoletosController.create);
routes.post("/assinatura", BoletosController.criarAssinaturaBoleto);
routes.get("/", BoletosController.getBoletos);
routes.get("/total-conta", BoletosController.getTotalConta);
routes.get("/:id", BoletosController.getUmBoleto);
routes.delete("/:id", BoletosController.delete);
routes.patch("/", BoletosController.update);

routes.get("/atrasados", BoletosController.getBoletosAtrasados);
routes.post("/gerar-boleto", BoletosController.gerarBoletoComNota);

module.exports = routes;