const ProdutosRepository = require("./produtos.repository");

class ProdutosController {
  async create(req, res) {
    try {
      const data = req.body; // obtém o ID do usuário autenticado
      const response = await ProdutosRepository.create(data);
      return res.status(response.code).json(response);
    } catch (error) {
      console.error(error);
      
      return res.status(error.code || 500).json(error);
    }
  }

  async getProdutos(req, res) {
    try {
      const response = await ProdutosRepository.getProdutos();
      return res.status(200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async getUmProduto(req, res) {
    try {
      const id = req.params.id;
      const response = await ProdutosRepository.getUmProduto(id);
      return res.status(response.code || 200).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async update(req, res) {
    try {
      const data = req.body;
      const response = await ProdutosRepository.update(data);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

  async delete(req, res) {
    try {
      const id = req.params.id;
      const response = await ProdutosRepository.delete(id);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }

    async removerProduto(req, res) {
    try {
      const data = req.body;
      const response = await ProdutosRepository.removerProduto(data);
      return res.status(response.code).json(response);
    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  }
}

module.exports = new ProdutosController();
