const db = require("../../config/db");

class ProdutosRepository {
  #db = db;

  /* ================= CREATE ================= */
  async create(data) {
    try {
      const result = await this.#db.query(
        `INSERT INTO produtos 
        (nome, data_criado, hora, quantidade, id_user)
        VALUES (?, ?, ?, ?, ?)`,
        [
          data.nome,
          data.data_criado,
          data.hora,
          data.quantidade,
          data.id_user,
        ]
      );

      return {
        error: false,
        message: "Produto criado com sucesso!",
        code: 201,
      };
    } catch (error) {
      console.error(error);
      return {
        error: true,
        message: "Erro ao criar produto",
        code: 500,
        detail: error,
      };
    }
  }

  /* ================= LISTAR TODOS ================= */
  async getProdutos() {
    try {
      const produtos = await this.#db.query(`SELECT * FROM produtos`);
      return produtos;
    } catch (error) {
      console.error(error);
      return {
        error: true,
        message: "Erro ao buscar produtos",
        code: 500,
        detail: error,
      };
    }
  }

  /* ================= BUSCAR UM ================= */
  async getUmProduto(id) {
    try {
      const produto = await this.#db.query(
        `SELECT * FROM produtos WHERE id = ?`,
        [id]
      );

      if (!produto.length) {
        return {
          error: true,
          message: "Produto não encontrado",
          code: 404,
        };
      }

      return produto[0];
    } catch (error) {
      console.error(error);
      return {
        error: true,
        message: "Erro ao buscar produto",
        code: 500,
        detail: error,
      };
    }
  }

  /* ================= UPDATE ================= */
  async update(data) {
    try {
      const fields = [];
      const values = [];

      if (data.nome) {
        fields.push("nome = ?");
        values.push(data.nome);
      }

      if (data.quantidade !== undefined) {
        fields.push("quantidade = ?");
        values.push(data.quantidade);
      }

      if (data.data_criado) {
        fields.push("data_criado = ?");
        values.push(data.data_criado);
      }

      if (data.hora) {
        fields.push("hora = ?");
        values.push(data.hora);
      }

      if (!fields.length) {
        return {
          error: true,
          message: "Nenhum dado para atualizar",
          code: 422,
        };
      }

      values.push(data.id);

      const result = await this.#db.query(
        `UPDATE produtos SET ${fields.join(", ")} WHERE id = ?`,
        values
      );

      if (result.affectedRows === 0) {
        return {
          error: true,
          message: "Produto não encontrado",
          code: 404,
        };
      }

      return {
        error: false,
        message: "Produto atualizado com sucesso!",
        code: 200,
      };
    } catch (error) {
      console.error(error);
      return {
        error: true,
        message: "Erro ao atualizar produto",
        code: 500,
        detail: error,
      };
    }
  }

  /* ================= DELETE ================= */
  async delete(id) {
    try {
      const result = await this.#db.query(
        `DELETE FROM produtos WHERE id = ?`,
        [id]
      );

      if (result.affectedRows === 0) {
        return {
          error: true,
          message: "Produto não encontrado",
          code: 404,
        };
      }

      return {
        error: false,
        message: "Produto deletado com sucesso!",
        code: 200,
      };
    } catch (error) {
      console.error(error);
      return {
        error: true,
        message: "Erro ao deletar produto",
        code: 500,
        detail: error,
      };
    }
  }

    async removerProduto(data) {
    try {
      const result = await this.#db.query(
        `UPDATE produtos 
       SET quantidade = quantidade - ? 
       WHERE id = ? 
       AND quantidade >= ?`,
        [data.quantidade, data.id, data.quantidade]
      );


      return {
        error: false,
        message: "Quantidade do produto removida com sucesso!",
        code: 200,
      };
    } catch (error) {
      console.error(error);
      return {
        error: true,
        message: "Erro ao remover quantidade do produto",
        code: 500,
        detail: error,
      };
    }
  }
}

module.exports = new ProdutosRepository();
