require("dotenv").config({ path: __dirname + "/../../.env" });




const GZAPPY_API_TOKEN = process.env.GZAPPY_API_TOKEN;
const GZAPPY_INSTANCE_ID = process.env.GZAPPY_INSTANCE_ID;
const S3_BUCKET = process.env.S3_BUCKET


const sendMessage = async (message, phoneNumber) => {
  try {

    const response = await fetch('https://v2-api.gzappy.com/message/send-text', {
      method: 'POST',
      headers: {
        'Authorization': `Bearer ${GZAPPY_API_TOKEN}`,
        'Content-Type': 'application/json'
      },
      body: JSON.stringify({
        phone: [phoneNumber],
        message: message
      })
    });

    const data = await response.json();
    console.log('Mensagem enviada com sucesso:', data);
  } catch (error) {
    console.error('Erro ao enviar mensagem:', error);
  }
};

// const sendMedia = async (message, phoneNumber, mediaUrl) => {
//   const GZAPPY_URL = "https://api.gzappy.com/v1/message/send-media"

//   const response = await fetch(GZAPPY_URL, {
//     method: 'POST',
//     headers: {
//         'Content-Type': 'application/json',
//         'Authorization': `Bearer ${GZAPPY_API_TOKEN}`
//     },
//     body: JSON.stringify({
//         instance_id: GZAPPY_INSTANCE_ID,
//         message: `${message}`,
//         phone: [`${phoneNumber}`], 
//         mediaUrl: mediaUrl
//     })
//   });
//   await console.log("sendMessage", response)
// }

const sendMedia = async (message, phoneNumber, mediaUrl) => {

  try {
    const response = await fetch('https://v2-api.gzappy.com/message/send-media', {
      method: 'POST',
      headers: {
        'Authorization': `Bearer ${GZAPPY_API_TOKEN}`,
        'Content-Type': 'application/json'
      },
      body: JSON.stringify({
        message: message,
        phone: [phoneNumber],
        media_public_url: mediaUrl
      })
    });

    console.log('Mensagem enviada com sucesso:', response);
  } catch (error) {
    console.error('Erro ao enviar mensagem:', error);
  }
};


const sendImage = async (phoneNumber, message, mediaUrl,) => {
  console.log("GZAPPY MEDIA ", mediaUrl);
  
  const GZAPPY_URL = "https://v2-api.gzappy.com/message/send-media";

  try {
    const response = await fetch(GZAPPY_URL, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'Authorization': `Bearer ${GZAPPY_API_TOKEN}`
      },
      body: JSON.stringify({
        instance_id: GZAPPY_INSTANCE_ID,
        message: message,
        phone: [phoneNumber],
        mediaUrl: mediaUrl
      })
    });

    const result = await response.json();
    console.log("✅ sendMedia result:", result);
    return result;
  } catch (error) {
    console.error("❌ Erro em sendMedia:", error);
    throw error;
  }
};

module.exports = { sendMessage, sendMedia, sendImage }